// PcanIsoTpExampleDlg.cpp : implementation file
//
#include "stdafx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CPcanIsoTpExampleDlg dialog
CPcanIsoTpExampleDlg::CPcanIsoTpExampleDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_PCANISOTPEXAMPLE_DIALOG, pParent),
	m_dlgMessages(NULL),
	m_dlgMappings(NULL),
	m_dlgParameters(NULL),
	m_pctpHandle(PCANTP_NONEBUS),
	m_baudrate(PCANTP_BAUD_500K),
	m_hwType(0),
	m_ioPort(0),
	m_interrupt(0)
{
	m_TabCtrl = new CPCanIsoTpExampleTabCtrl();
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}


void CPcanIsoTpExampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TABCTRL, *m_TabCtrl);
	DDX_Control(pDX, IDC_COMBO_BAUDRATE, comboBoxBaudrate);
	DDX_Control(pDX, IDC_COMBO_HWTYPE, comboBoxHwType);
	DDX_Control(pDX, IDC_COMBO_IOPORT, comboBoxIoPort);
	DDX_Control(pDX, IDC_COMBO_INTERRUPT, comboBoxInterrupt);
	DDX_Control(pDX, IDC_COMBO_CHANNEL, comboBoxChannel);
	DDX_Control(pDX, IDC_BUTTON_INIT, buttonInit);
	DDX_Control(pDX, IDC_BUTTON_REFRESH, buttonHwRefresh);
	DDX_Control(pDX, IDC_BUTTON_RELEASE, buttonRelease);
	DDX_Control(pDX, IDC_CHECK_FD, checkBoxCanFd);
	DDX_Control(pDX, IDC_EDIT_FD, textBoxCanFdBitrate);
	DDX_Control(pDX, IDC_STATIC_BAUDRATE, labelBaudrate);
	DDX_Control(pDX, IDC_STATIC_HWTYPE, labelHardwareType);
	DDX_Control(pDX, IDC_STATIC_IOPORT, labelIOPort);
	DDX_Control(pDX, IDC_STATIC_BITRATE, labelBitrate);
	DDX_Control(pDX, IDC_STATIC_INTERRUPT, labelInterrupt);
	DDX_Text(pDX, IDC_EDIT_FD, m_textCanFd);
}

BEGIN_MESSAGE_MAP(CPcanIsoTpExampleDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_REFRESH, &CPcanIsoTpExampleDlg::OnBnClickedButtonRefresh)
	ON_BN_CLICKED(IDC_BUTTON_INIT, &CPcanIsoTpExampleDlg::OnBnClickedButtonInit)
	ON_CBN_SELCHANGE(IDC_COMBO_CHANNEL, &CPcanIsoTpExampleDlg::OnCbnSelchangeComboChannel)
	ON_CBN_SELCHANGE(IDC_COMBO_BAUDRATE, &CPcanIsoTpExampleDlg::OnCbnSelchangeComboBaudrate)
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_WM_NCDESTROY()
	ON_CBN_SELCHANGE(IDC_COMBO_HWTYPE, &CPcanIsoTpExampleDlg::OnCbnSelchangeComboHwtype)
	ON_CBN_SELCHANGE(IDC_COMBO_IOPORT, &CPcanIsoTpExampleDlg::OnCbnSelchangeComboIoport)
	ON_CBN_SELCHANGE(IDC_COMBO_INTERRUPT, &CPcanIsoTpExampleDlg::OnCbnSelchangeComboInterrupt)
	ON_BN_CLICKED(IDC_BUTTON_RELEASE, &CPcanIsoTpExampleDlg::OnBnClickedButtonRelease)
	ON_BN_CLICKED(IDC_CHECK_FD, &CPcanIsoTpExampleDlg::OnBnClickedCheckFd)
	ON_EN_CHANGE(IDC_EDIT_FD, &CPcanIsoTpExampleDlg::OnEnChangeEditFd)
END_MESSAGE_MAP()


// CPcanIsoTpExampleDlg message handlers
BOOL CPcanIsoTpExampleDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_TabCtrl->InitDialogs(&m_pctpHandle);
	// Add 3 tabs : Parameters, Mappings and Messages
	m_TabCtrl->InsertItem(0, L"Parameters");
	m_TabCtrl->InsertItem(1, L"Mappings");
	m_TabCtrl->InsertItem(2, L"Messages");

	m_TabCtrl->ActivateTabDialogs();
	m_dlgParameters = (CPCanIsoTpExampleDlgParameters *)m_TabCtrl->m_Dialog[0]; // Get instance CPCanIsoTpExampleDlgParameters address
	m_dlgMappings = (CPCanIsoTpExampleDlgMappings *)m_TabCtrl->m_Dialog[1]; // Get instance CPCanIsoTpExampleDlgMappings address
	m_dlgMessages = (CPCanIsoTpExampleDlgMessages *)m_TabCtrl->m_Dialog[2]; // Get instance CPCanIsoTpExampleDlgMessages address

	try
	{
		char buf[50] = {'\0'};
		TPCANTPStatus sts;
		// Get API version
		sts = CANTP_GetValue(PCANTP_NONEBUS, PCANTP_PARAM_API_VERSION, buf, 50);
		CString outputMessage(buf);
		CPCanIsoTpUtils::checkCanTpStatus(PCANTP_NONEBUS, sts, buf, PCANTP_PARAM_API_VERSION);
	}
	catch (...)
	{
		MessageBox(L"Unable to find one of required PCAN libraries: PCANBasic.dll or PCAN-ISO-TP.dll.", L"Error!",
			MB_ICONERROR | MB_OK);
		exit(EXIT_FAILURE);
	}
	InitializeUiConnection(); // initialization of UI components
	InitializeUiTabParameters(); // initialization of UI components
	SetConnectionStatus(isConnected());
	m_textCanFd = L"f_clock_mhz=20, nom_brp=5, nom_tseg1=2, nom_tseg2=1, nom_sjw=1, data_brp=2, data_tseg1=3, data_tseg2=1, data_sjw=1";
	textBoxCanFdBitrate.SetWindowTextW(m_textCanFd);
	OnBnClickedCheckFd(); // initialization of UI components for FD messages
	return TRUE;  // return TRUE  unless you set the focus to a control
}


// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.
void CPcanIsoTpExampleDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPcanIsoTpExampleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

/// <summary>
/// First initialization of UI components of the "Connection" tab.
/// </summary>
void CPcanIsoTpExampleDlg::InitializeUiConnection() 
{
	// fill combobox "comboBoxBaudrate"
	comboBoxBaudrate.ResetContent();
	for (UINT i = 0; i < m_pctpBaudrates.size(); i++) {
		int indexBaudrate = comboBoxBaudrate.AddString(CPCanIsoTpUtils::GetBitrate(m_pctpBaudrates[i]));
		comboBoxBaudrate.SetItemData(indexBaudrate, m_pctpBaudrates[i]);
	}
	comboBoxBaudrate.SelectString(0, L"500 kBit/s"); // sets the default value
	TPCANTPBaudrate baudrate = (TPCANTPBaudrate)comboBoxBaudrate.GetItemData(comboBoxBaudrate.GetCurSel());
	// Send message to notify combobox of selection has changed
	OnCbnSelchangeComboBaudrate();

	// fill combobox "comboBoxHwType"
	comboBoxHwType.ResetContent();
	for (UINT i = 0; i < m_pctpHWType.size(); i++) {
		int indexHWType = comboBoxHwType.AddString(m_pctpHWType[i].second);
		comboBoxHwType.SetItemData(indexHWType, m_pctpHWType[i].first);
	}
	comboBoxHwType.SetCurSel(comboBoxHwType.FindStringExact(0, L"PCANTP_TYPE_ISA"));
	int hardwaretype = comboBoxHwType.GetItemData(comboBoxHwType.GetCurSel());
	// Send message to notify combobox of selection has changed
	OnCbnSelchangeComboHwtype();

	// fill combobox "comboBoxIoPort"
	comboBoxIoPort.ResetContent();
	for (UINT i = 0; i < m_pctIoPort.size(); i++) {
		int indexIoPort = comboBoxIoPort.AddString(m_pctIoPort[i]);
		comboBoxIoPort.SetItemData(indexIoPort, CPCanIsoTpUtils::HexStrToDec(m_pctIoPort[i]));
	}
	comboBoxIoPort.SelectString(0, L"0100"); // sets the default value
	// Send message to notify combobox of selection has changed
	OnCbnSelchangeComboIoport();

	
	// fill combobox "comboBoxInterrupt"
	comboBoxInterrupt.ResetContent();
	for (UINT i = 0; i < m_pctInterrupt.size(); i++) {
		int indexInterrupt = comboBoxInterrupt.AddString(m_pctInterrupt[i]);
		comboBoxInterrupt.SetItemData(indexInterrupt, _wtol(m_pctInterrupt[i]));
	}
	comboBoxInterrupt.SelectString(0, L"3");
	// Send message to notify combobox of selection has changed
	OnCbnSelchangeComboInterrupt();
	// fill combobox "comboBoxChannel"
	OnBnClickedButtonRefresh();
	// Select the last item in the combo box.
	int nLast = comboBoxChannel.GetCount() - 1;
	if (nLast >= 0)
		comboBoxChannel.SetCurSel(nLast);
}


/// <summary>
/// Event handler called when button "Hardware Refresh" is clicked.
/// </summary>
void CPcanIsoTpExampleDlg::OnBnClickedButtonRefresh()
{
	TPCANTPStatus sts = 0;
	UINT32 iBuffer = 0;           // temporary buffer to retrieve the condition of a channel
	CString strCurrSelection = L"";  // store the currently selected channel in the "channel" comboBox
	CString strNewItem = L"";		 // new channel in the "channel" comboBox
	int indexHandle = 0;

	// Get selected item first (to set it back later).
	if (comboBoxChannel.GetCurSel() >= 0) {
		comboBoxChannel.GetLBText(comboBoxChannel.GetCurSel(), strCurrSelection);
	}

	// Clears the "Channel" comboBox and fill it again with 
	//  all the PCAN-ISO-TP handles (non-plug'n'play hardware and
	//  the detected Plug'n'Play hardware).
	comboBoxChannel.ResetContent();
	// Loop through all known PCAN-ISO-TP handles.
	for (UINT i = 0; i < m_pctpHandles.size(); i++)
	{
		// Initializes an item for the comboBox.
		// Automatically add non-plug'n'play handles.
		if (m_pctpHandles[i].first <= PCANTP_DNGBUS1) {
			strNewItem = m_pctpHandles[i].second + L" (" + CPCanIsoTpUtils::IntToHex(m_pctpHandles[i].first, 0) + L"h)";
			indexHandle = comboBoxChannel.AddString(strNewItem);
			comboBoxChannel.SetItemData(indexHandle, m_pctpHandles[i].first);
		}
		else
		{
			// Check the availalility of plug'n'play handles.
			sts = CANTP_GetValue(m_pctpHandles[i].first, PCANTP_PARAM_CHANNEL_CONDITION, &iBuffer, sizeof(iBuffer));
			if (sts == PCANTP_ERROR_OK && ((iBuffer & PCANTP_CHANNEL_AVAILABLE) == PCANTP_CHANNEL_AVAILABLE))
			{
				// Channel is available, add it to the comboBox.
				strNewItem = m_pctpHandles[i].second + L" (" + CPCanIsoTpUtils::IntToHex(m_pctpHandles[i].first, 0) + L"h)";
				indexHandle = comboBoxChannel.AddString(strNewItem);
				comboBoxChannel.SetItemData(indexHandle, m_pctpHandles[i].first);
			}
		}
		// Select the handle if it was the previously selected one.
		if (strCurrSelection == strNewItem) {
			comboBoxChannel.SelectString(0, strCurrSelection);
		}
		else {
			comboBoxChannel.SelectString(0, strNewItem);
		}
	}
	// Send message to notify combobox of selection has changed
	OnCbnSelchangeComboChannel();
}

/// <summary>
/// Event handler called when button "Initialize" is clicked.
/// </summary>
void CPcanIsoTpExampleDlg::OnBnClickedButtonInit()
{
	CString currText = 0;
	if (comboBoxChannel.GetCurSel() == CB_ERR)
		return; // No channel is selected
	// Read the HarwareType, IO port and Interrupt only 
	//  if the selected device is not plug'n'play.
	if (m_pctpHandle <= PCANTP_DNGBUS1)
	{
		m_hwType = (TPCANTPHWType)comboBoxHwType.GetItemData(comboBoxHwType.GetCurSel());
		m_ioPort = (UINT32)comboBoxIoPort.GetItemData(comboBoxIoPort.GetCurSel());
		m_interrupt = (byte)comboBoxInterrupt.GetItemData(comboBoxInterrupt.GetCurSel());
	}
	else
	{
		m_hwType = 0;
		m_ioPort = 0;
		m_interrupt = 0;
	}
	// Connects to the selected PCAN-ISO-TP channel.
	Connect(m_pctpHandle, m_baudrate, m_hwType, m_ioPort, m_interrupt);
	// Start read on timer
	m_dlgMessages->OnBnClickedRadioTimer();
}

/// <summary>
/// Connects to a PCAN ISO-TP channel and sets m_pctpHandle.
/// </summary>
/// <param name="p_canHandle">A PCANTP Channel Handle representing a PCANTP-Client</param>
/// <param name="p_baudrate">The CAN Hardware speed</param>
/// <param name="p_hwType">Non plug-'n-play: The type of hardware and operation mode</param>
/// <param name="p_ioPort">Non plug-'n-play: The I/O address for the parallel port</param>
/// <param name="p_interrupt">Non plug-'n-play: Interrupt number of the parallel port</param>
/// <returns>true is returned on success</returns>
bool CPcanIsoTpExampleDlg::Connect(TPCANTPHandle p_canHandle, TPCANTPBaudrate p_baudrate, TPCANTPHWType p_hwType, UINT32 p_ioPort, byte p_interrupt)
{
	TPCANTPStatus sts;
	char bufferTextCanFd[4096] = { '\0' }; // char buffer


	// Connects to the selected PCAN-ISO-TP channel.
	// If FD support
	if (checkBoxCanFd.GetCheck() == 1)
	{
		// Convert unicode string to multibytes char
		CPCanIsoTpUtils::ConvertUnicodeCharToMultibytesChar(m_textCanFd, bufferTextCanFd);
		sts = CANTP_InitializeFD(p_canHandle, bufferTextCanFd);
		CPCanIsoTpUtils::checkCanTpStatus(p_canHandle, sts, bufferTextCanFd);
	}
	else
	{
		sts = CANTP_Initialize(p_canHandle, p_baudrate, p_hwType, p_ioPort, p_interrupt);
		CPCanIsoTpUtils::checkCanTpStatus(p_canHandle, sts, { p_baudrate, p_hwType, (int)p_ioPort, p_interrupt });
	}

	// Sets the connection status of the main-form.
	SetConnectionStatus(isConnected());

	if (sts == PCANTP_ERROR_OK)
	{
		// Clear mappings.
		m_dlgMappings->MappingsInit();
		m_dlgMessages->FillComboMappings();
	}
	else {
		m_pctpHandle = PCANTP_NONEBUS;
	}
	return (m_pctpHandle != PCANTP_NONEBUS);
}

/// <summary>
/// Event handler called when selection of comboBox "channel handles" is changed.
/// </summary>
void CPcanIsoTpExampleDlg::OnCbnSelchangeComboChannel()
{
	BOOL isNotPnp = TRUE;
	int iCurSel = comboBoxChannel.GetCurSel();

	// Gets the selected ISO-TP channel.
	m_pctpHandle = (TPCANTPHandle)comboBoxChannel.GetItemData(iCurSel);

	// If Selection <= PCANTP_DNGBUS1
	isNotPnp = (m_pctpHandle <= PCANTP_DNGBUS1);

	// Enables/Disables connection ComboBox upon the Channel selection
	comboBoxHwType.EnableWindow(isNotPnp);
	comboBoxInterrupt.EnableWindow(isNotPnp);
	comboBoxIoPort.EnableWindow(isNotPnp);
}

/// <summary>
/// Activates/deactivates the different controls of the main-form according
/// with the current connection status
/// </summary>
/// <param name="p_bConnected">Current status. True if connected, false otherwise</param>
void CPcanIsoTpExampleDlg::SetConnectionStatus(bool p_bConnected) {

	// Connection components
	buttonInit.EnableWindow(!p_bConnected);
	checkBoxCanFd.EnableWindow(!p_bConnected);
	buttonRelease.EnableWindow(p_bConnected);
	buttonHwRefresh.EnableWindow(!p_bConnected);
	comboBoxChannel.EnableWindow(!p_bConnected);
	comboBoxBaudrate.EnableWindow(!p_bConnected);
	comboBoxHwType.EnableWindow(!p_bConnected && (m_pctpHandle <= PCANTP_DNGBUS1));
	comboBoxIoPort.EnableWindow(!p_bConnected && (m_pctpHandle <= PCANTP_DNGBUS1));
	comboBoxInterrupt.EnableWindow(!p_bConnected && (m_pctpHandle <= PCANTP_DNGBUS1));

	// Parameters components
	m_dlgParameters->buttonParamReset.EnableWindow(p_bConnected);
	m_dlgParameters->buttonParamStatus.EnableWindow(p_bConnected);
	m_dlgParameters->buttonParamSet.EnableWindow(p_bConnected);
	m_dlgParameters->buttonParamGet.EnableWindow(p_bConnected);
	m_dlgParameters->OnCbnSelchangeComboParam();

	// Mappings components
	m_dlgMappings->buttonMappingAdd.EnableWindow(p_bConnected);
	m_dlgMappings->buttonMappingDel.EnableWindow(p_bConnected);
	m_dlgMappings->buttonSaveMappings.EnableWindow(p_bConnected);
	m_dlgMappings->buttonLoadMappings.EnableWindow(p_bConnected);
	m_dlgMappings->buttonMappingSample.EnableWindow(p_bConnected);
	m_dlgMappings->listViewMappings.EnableWindow(p_bConnected);

	// Messages components
	m_dlgMessages->buttonMsgRead.EnableWindow(p_bConnected);
	m_dlgMessages->buttonMsgWrite.EnableWindow(p_bConnected);
	m_dlgMessages->comboBoxMsgMapping.EnableWindow(p_bConnected);
	m_dlgMessages->listViewMsgs.EnableWindow(p_bConnected);
	m_dlgMessages->radioButtonMsgTimer.EnableWindow(p_bConnected);
	m_dlgMessages->radioButtonMsgEvent.EnableWindow(p_bConnected);
	m_dlgMessages->radioButtonMsgManual.EnableWindow(p_bConnected);
}


/// <summary>
/// First initialization of UI components of the "Parameter" tab.
/// </summary>
void CPcanIsoTpExampleDlg::InitializeUiTabParameters()
{
	TPCANTPParameter param = 0;
	int index = 0;
	// fill combobox "comboBoxParameter"
	m_dlgParameters->comboBoxParameter.ResetContent();

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_API_VERSION));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_API_VERSION);

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_CHANNEL_CONDITION));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_CHANNEL_CONDITION);

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_DEBUG));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_DEBUG);

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_RECEIVE_EVENT));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_RECEIVE_EVENT);

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_MSG_PENDING));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_MSG_PENDING);

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_BLOCK_SIZE));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_BLOCK_SIZE);

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_SEPARATION_TIME));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_SEPARATION_TIME);

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_WFT_MAX));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_WFT_MAX);

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_PADDING_VALUE));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_PADDING_VALUE);

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_CAN_DATA_PADDING));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_CAN_DATA_PADDING);

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_J1939_PRIORITY));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_J1939_PRIORITY);

	index = m_dlgParameters->comboBoxParameter.AddString(CPCanIsoTpUtils::GetParameter(PCANTP_PARAM_CAN_TX_DL));
	m_dlgParameters->comboBoxParameter.SetItemData(index, PCANTP_PARAM_CAN_TX_DL);

	// Set default parameter to API
	m_dlgParameters->comboBoxParameter.SetCurSel(0);
}

/// <summary>
/// Event handler called when button "Combobox Baudrate" is clicked.
/// </summary>
void CPcanIsoTpExampleDlg::OnCbnSelchangeComboBaudrate()
{
	// Gets the selected p_baudrate.
	m_baudrate = (TPCANTPBaudrate)comboBoxBaudrate.GetItemData(comboBoxBaudrate.GetCurSel());
}

/// <summary>
/// Disconnects the currently connected channel (m_pctpHandle)
/// </summary>
/// <returns>true is returned on success</returns>
bool CPcanIsoTpExampleDlg::Disconnect()
{
	TPCANTPStatus sts;

	// Disconnects from selected PCAN-ISO-TP channel
	sts = CANTP_Uninitialize(m_pctpHandle);
	CPCanIsoTpUtils::checkCanTpStatus(m_pctpHandle, sts);
	if (sts == PCANTP_ERROR_OK)
	{
		// Reset stored mappings.
		m_dlgMappings->ResetMappingList();
		m_dlgMappings->MappingsChanged();
		m_dlgMessages->checkBoxHasPriority.SetCheck(0);
		m_dlgMessages->checkBoxHasPriority.EnableWindow(false);
		m_dlgMessages->editPriority.EnableWindow(false);
		m_dlgMessages->numericUpDownPriority.EnableWindow(false);
	}
	SetConnectionStatus(isConnected());
	return isConnected();
}

/// <summary>
/// States if an ISO-TP channel is currently connected.
/// </summary>
/// <returns>true if a channel is connected.</returns>
bool CPcanIsoTpExampleDlg::isConnected()
{
	return PCANTP_ERROR_NOT_INITIALIZED != CANTP_GetStatus(m_pctpHandle);
}


/// <summary>
/// Event called when app is closed
/// </summary>
void CPcanIsoTpExampleDlg::OnClose()
{
	comboBoxBaudrate.Clear();
	comboBoxChannel.Clear();
	comboBoxHwType.Clear();
	comboBoxInterrupt.Clear();
	comboBoxIoPort.Clear();

	if (isConnected()) Disconnect();

	m_TabCtrl->DestroyWindow();	// m_TabCtrl is auto deleted in its own override method PostNcDestroy with "delete this"
	
	// Add code before OnClose();
	CDialogEx::OnClose();
}


/// <summary>
/// Event called when Combobox Harware Type is clicked
/// </summary>
void CPcanIsoTpExampleDlg::OnCbnSelchangeComboHwtype()
{
	m_hwType = (TPCANTPHWType)comboBoxHwType.GetItemData(comboBoxBaudrate.GetCurSel());
}

/// <summary>
/// Event called when Combobox IO Port is clicked
/// </summary>
void CPcanIsoTpExampleDlg::OnCbnSelchangeComboIoport()
{
	m_ioPort = (UINT32)comboBoxIoPort.GetItemData(comboBoxBaudrate.GetCurSel());
}


/// <summary>
/// Event called when Combobox Interrupt is clicked
/// </summary>
void CPcanIsoTpExampleDlg::OnCbnSelchangeComboInterrupt()
{
	m_interrupt = (BYTE)comboBoxHwType.GetItemData(comboBoxBaudrate.GetCurSel());
}


/// <summary>
/// Event called when the Dialog is destroyed
/// </summary>
BOOL CPcanIsoTpExampleDlg::DestroyWindow()
{
	return CDialogEx::DestroyWindow();
}


/// <summary>
/// Event called when Release button is clicked
/// </summary>
void CPcanIsoTpExampleDlg::OnBnClickedButtonRelease()
{
	Disconnect();
}


/// <summary>
/// Manage FD checkboxes when FD support is checked
/// </summary>
void CPcanIsoTpExampleDlg::OnBnClickedCheckFd()
{
	m_bCanFdSupport = checkBoxCanFd.GetCheck() == 1;
	textBoxCanFdBitrate.ShowWindow(m_bCanFdSupport);
	labelBitrate.ShowWindow(m_bCanFdSupport);

	labelBaudrate.ShowWindow(!m_bCanFdSupport);
	labelHardwareType.ShowWindow(!m_bCanFdSupport);
	labelIOPort.ShowWindow(!m_bCanFdSupport);
	labelInterrupt.ShowWindow(!m_bCanFdSupport);
	comboBoxBaudrate.ShowWindow(!m_bCanFdSupport);
	comboBoxHwType.ShowWindow(!m_bCanFdSupport);
	comboBoxIoPort.ShowWindow(!m_bCanFdSupport);
	comboBoxInterrupt.ShowWindow(!m_bCanFdSupport);

	m_dlgMessages->ManageUIForFD(m_bCanFdSupport);
}


void CPcanIsoTpExampleDlg::OnEnChangeEditFd()
{
	textBoxCanFdBitrate.GetWindowTextW(m_textCanFd);
}
